// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: graph.h 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef GRAPH_H
#define GRAPH_H

#include <string>
#include <vector>
#include <ext/hash_map>

class Node;
class Edge;
class option;

class Graph {
public:
    typedef __gnu_cxx::hash_map<int, Node*> map_t;
    map_t nodes;
    std::vector<Edge*> edges;
    std::vector<Node*> targets;
    Node* initial;

    Node* getNode(int id);

    Graph();

    std::vector<Node*>& getTargets();

    void setTarget(int node);
    void setInitial(int node);
    void labelNode(int node, const char* label);
    void addEdge(int from, int to);
    void show(std::ostream& o, const option& opts) const;
    void show(const char* filename, const option& opts) const;
    void dump(std::ostream& o) const;

    friend std::ostream& operator<<(std::ostream& o, const Graph& g);
    friend class Explorer;
};

#endif /* GRAPH_H */
