// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: explorer.cpp 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "explorer.h"
#include "graph.h"
#include "edge.h"

#include <vector>
#include <cassert>
#include <climits>
#include <iostream>
#include <queue>
#include <set>
#include <boost/foreach.hpp>
#define foreach BOOST_FOREACH

using namespace std;

Explorer::Explorer(Graph* graph) :
    graph(graph),
    open(graph->nodes.size())
{}

void Explorer::explore() {
    vector<Node*>& targets = graph->getTargets();
    for (int i = 0; i < targets.size(); ++i) {
        open.push_back(targets[i]);
    }

    while (!open.empty()) {
        Node* current = open.front();
        open.pop_front();

        for (Node::iterator it = current->begin(); it != current->end(); ++it) {
            Node* successor = (*it)->from;

            if (successor->distance > current->distance) {
                successor->distance = current->distance + 1;
                open.push_back(successor);
            }
        }
    }
}
