// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: edge.cpp 939 2016-05-27 11:56:45Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "edge.h"
#include "node.h"
#include <iostream>

using namespace std;

Edge::Edge(Node* from, Node* to) :
    from(from),
    to(to) {
    from->addOutgoing(this);
    to->addIncoming(this);
}

bool Edge::operator==(const Edge& rhs) const {
    return *from == *rhs.from && *to == *rhs.to;
}

ostream& operator<<(ostream& o, const Edge& edge) {
    return o << *edge.from << " -> " << *edge.to;
}
