// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: zone.cpp 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "process.h"
#include "system.h"
#include "variable.h"
#include "zone.h"

#include <boost/foreach.hpp>
#include <cassert>
#include <iomanip>
#include <ostream>
#define foreach BOOST_FOREACH

using namespace std;

MyClockAccessor::MyClockAccessor(const System* system) :
    system(system)
{}

const string MyClockAccessor::getClockName(cindex_t index) const {
    uint32_t c = system->clocks.size();
    if (index < c) {
        return system->clocks[index]->name;
    }
    index -= c;
    foreach(const Process * p, system->procs) {
        c = p->clocks.size();
        if (index < c) {
            return p->name + "." + p->clocks[index]->name;
        }
        index -= c;
    }
    assert(false);
    return "";
}

ostream& dump(ostream& out, const dbm::dbm_t& zone) {
    for (uint32_t i = 0; i < zone.getDimension(); ++i) {
        for (uint32_t j = 0; j < zone.getDimension(); j++) {
            out << setw(12) << zone(i, j) << " ";
        }
        out << endl;
    }
    return out;
}
