// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: varset.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_VARSET_H
#define SYSTEM_VARSET_H

#include <inttypes.h>
#include <iosfwd>
#include <set>

class Variable;

class varset_t {
private:
    typedef std::set<const Variable*> set_t;
    set_t vars;
public:
    typedef set_t::iterator iterator;
    typedef set_t::const_iterator const_iterator;

    varset_t() : vars() {}
    varset_t(const varset_t& other) : vars(other.vars) {}
    varset_t(const Variable* var) {vars.insert(var); }

    varset_t& operator+=(const varset_t& rhs) {
        vars.insert(rhs.begin(), rhs.end());
        return *this;
    }
    varset_t operator+=(const Variable* var) {
        vars.insert(var);
        return *this;
    }
    bool contains(const Variable* var) const {
        return vars.find(var) != vars.end();
    }
    bool empty() const {return vars.empty(); }
    uint32_t size() const {return vars.size(); }

    iterator begin() {return vars.begin(); }
    iterator end() {return vars.end(); }

    const_iterator begin() const {return vars.begin(); }
    const_iterator end() const {return vars.end(); }

    std::ostream& display(std::ostream& o) const;
};

inline std::ostream& operator<<(std::ostream& o, const varset_t& vs) {
    return vs.display(o);
}

#endif /* SYSTEM_VARSET_H */
