// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: target.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_TARGET_H
#define SYSTEM_TARGET_H

#include "constraint.h"
#include "constraint_container.h"
#include "varset.h"

#include <vector>

class Target : public ConstraintContainer {
private:
    Conjunction<LocationConstraint> locConstraints;
    Conjunction<IntConstraint> intConstraints;

public:
    Target();

    virtual void addIntConstraint(IntConstraint* ic);
    virtual void addClockConstraint(ClockConstraint* cc);
    virtual void addLocationConstraint(LocationConstraint* lc);
    virtual bool isSatBy(const State* state) const;
    virtual varset_t readVars() const;
    virtual varset_t writeVars() const;
    virtual void eraseConstraint(std::string varname, std::vector<const Constraint*>& removed_target_constraints);

    const Conjunction<LocationConstraint>& getLocationConstraints() const {
        return locConstraints;
    }

    const Conjunction<IntConstraint>& getIntConstraints() const {
        return intConstraints;
    }

    virtual std::ostream& display(std::ostream& o) const;
};

////////////////////////////////////////////////////////////////////

inline bool Target::isSatBy(const State* state) const {
    return locConstraints.isSatBy(state) && intConstraints.isSatBy(state);
}

#endif /* SYSTEM_TARGET_H */
