// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: system_builder.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_SYSTEM_BUILDER_H
#define SYSTEM_SYSTEM_BUILDER_H

#include <inttypes.h>
#include <string>

#include "common/utapfwd.h"

class Channel;
class Component;
class Location;
class NameResolver;
class Process;
class System;

class SystemBuilder {
private:
    mutable uint32_t nrEdges;
    mutable uint32_t nrProcs;
    mutable uint32_t nrLocs;
    mutable uint32_t nrClocks;
    mutable uint32_t nrInts;
    mutable uint32_t nrChans;

    mutable NameResolver* resolver;

    void addInteger(const UTAP::variable_t& var, Component* comp) const;
    void addClock(const UTAP::variable_t& var, Component* comp) const;
    void addChannel(const UTAP::variable_t& var, Component* comp) const;
    void addConstant(const UTAP::variable_t& var, Component* comp) const;
    void addVariable(const UTAP::variable_t& var, Component* comp) const;
    void addProcess(const UTAP::instance_t& proc, System* system) const;
    void addLocation(const UTAP::state_t& state, Process* proc) const;
    void addEdge(const UTAP::edge_t& edge, Process* proc) const;

    void setChannelType(const UTAP::type_t& type, Channel* channel) const;
    void setLocationType(const UTAP::type_t& type, Location* location) const;

public:
    SystemBuilder();
    System* buildSystem(UTAP::TimedAutomataSystem* system) const;
};

#endif /* SYSTEM_SYSTEM_BUILDER_H */
