// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: system.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_SYSTEM_H
#define SYSTEM_SYSTEM_H

#include "component.h"
#include "state.h"

#include <inttypes.h>

class NameResolver;
class Process;
class Variable;

class System : public Component {
public:
    NameResolver* resolver;
    mutable StateBuilder* builder;
    std::vector<Process*> procs;

    System();
    virtual ~System() {}

    void prepare();

    uint32_t getTotalNrClocks() const;
    uint32_t getTotalNrChannels() const;
    uint32_t getTotalNrIntegers() const;
    uint32_t getTotalNrLocations() const;
    uint32_t getTotalNrEdges() const;

    uint32_t getTotalNrIntAssignments() const;
    uint32_t getTotalNrIntConstraints() const;

    const Integer* getInteger(int32_t id) const;

    State* createInitial() const;
    bool isCommitted(const State* state) const;

    virtual uint32_t getNrChannels() const;

    Variable* find(const Component* comp, const std::string& name) const;
    virtual const Component* getComponent(const std::string& compname) const;
    virtual std::ostream& display(std::ostream& o) const;
};

#endif /* SYSTEM_SYSTEM_H */
