// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: resolver.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_RESOLVER_H
#define SYSTEM_RESOLVER_H

#include "common/utapfwd.h"

#include <inttypes.h>
#include <iosfwd>
#include <map>
#include <string>
#include <vector>

class Channel;
class Clock;
class Component;
class Constant;
class Integer;
class Location;
class Variable;

class NameResolver {
    class ComponentVars {
public:
        ComponentVars() {}

        std::vector<Variable*> children;
        std::vector<Constant*> consts;

        std::ostream& display(std::ostream& o) const;
    };

    typedef std::map<const Component*, ComponentVars> lookup_t;
    lookup_t lookup;

    void addChild(const Component* comp, Variable* var);

public:
    uint32_t size() const {return lookup.size(); }

    void addInteger(const Component* comp, Integer* integer);
    void addClock(const Component* comp, Clock* clock);
    void addChannel(const Component* comp, Channel* channel);
    void addConstant(const Component* comp, Constant* constant);
    void addLocation(const Component* comp, Location* loc);
    Constant* findConst(const Component* comp, const UTAP::expression_t& expr) const;
    Variable* find(const Component* comp, const std::string& name) const;
    Variable* getChild(const Component* comp, uint32_t index) const;

    std::ostream& display(std::ostream& o) const;
};

inline std::ostream& operator<<(std::ostream& o, const NameResolver& nr) {
    return nr.display(o);
}

#endif /* SYSTEM_RESOLVER_H */
