// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: process.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_PROCESS_H
#define SYSTEM_PROCESS_H

#include "system/component.h"
#include <inttypes.h>

class Edge;
class Location;
class System;

class Process : public Component {
public:
    std::vector<Location*> locs;
    std::vector<Edge*> edges;
    Location* init;
    int32_t id;

    Process(const std::string& name, Component* parent, int32_t id);
    virtual ~Process();

    Location* getLocationByName(const std::string& locname) const;
    virtual std::ostream& display(std::ostream& o) const;
};

#endif /* SYSTEM_PROCESS_H */
