// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: process.cpp 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "edge.h"
#include "location.h"
#include "process.h"

#include "common/helper.h"

#include <boost/foreach.hpp>
#include <cassert>
#include <iostream>
#define foreach BOOST_FOREACH

using namespace std;

Process::Process(const string& name, Component* parent, int32_t id) :
    Component(name, parent),
    locs(),
    edges(),
    init(NULL),
    id(id)
{}

Process::~Process() {
    deleteVector(edges);
    deleteVector(locs);
}

Location* Process::getLocationByName(const string& locname) const {
    foreach(Location* loc, locs) {
        assert(loc);
        if (loc->name == locname) {
            return loc;
        }
    }
    return NULL;
}

ostream& Process::display(ostream& o) const {
    o << "process " << name << " {" << endl;
    Component::display(o);
    o << endl;
    o << "    state ";
    printPtrVector(locs, ", ", o) << ";" << endl;
    bool has_commit = false;
    foreach(const Location* l, locs) {
        if (l->commit) {
            if (!has_commit) {
                o << "    commit " << l->name;
                has_commit = true;
            } else {
                o << ", " << l->name;
            }
        }
    }
    if (has_commit) {
        o << ";" << endl;
    }

    o << "    init " << init->name << ";" << endl;
    if (!edges.empty()) {
        o << "    trans " << endl << "    ";
        printPtrVector(edges, ",\n    ", o);
        o << ";" << endl;
    }
    return o << "}" << endl;
}
