// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: parser.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_PARSER_H
#define SYSTEM_PARSER_H

#include <string>
#include "system/resolver.h"

class Task;

class SystemParser {
private:
    SystemParser() {}
    const SystemParser& operator=(const SystemParser&);
public:
    static SystemParser& parser() {
        static SystemParser theParser;
        return theParser;
    }

    Task* operator()(const std::string& tafile, bool oldSyntax);
    Task* operator()(const char* tafile, bool oldSyntax);

    Task* operator()(const std::string& tafile, const std::string& qfile, bool oldSyntax);
    Task* operator()(const char* tafile, const char* qfile, bool oldSyntax);
};

#endif /* SYSTEM_PARSER_H */
