// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: location.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_LOCATION_H
#define SYSTEM_LOCATION_H

#include "variable.h"
#include <vector>

class Process;
class Invariant;
class Edge;

class Location : public Variable {
public:
    Process* proc;
    bool urgent;
    bool commit;
    uint32_t idInSystem;
    uint32_t idInProcess;
    Invariant* inv;
    std::vector<Edge*> outgoing;
    std::vector<Edge*> incoming;

    Location(Process* proc, const std::string& name, uint32_t idInProcess, uint32_t idInSystem);
    virtual ~Location();
    virtual std::ostream& display(std::ostream& o) const;
};

#endif /* SYSTEM_LOCATION_H */
