// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: location.cpp 816 2011-09-10 13:19:07Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#include "edge.h"
#include "invariant.h"
#include "location.h"
#include "process.h"

#include <cassert>
#include <ostream>

using namespace std;

Location::Location(Process* proc, const std::string& name, uint32_t idInProcess, uint32_t idInSystem) :
    Variable(name, Expression::LOCATION),
    proc(proc),
    urgent(false),
    commit(false),
    idInSystem(idInSystem),
    idInProcess(idInProcess),
    inv(NULL)
{}

Location::~Location() {
    delete inv;
}

ostream& Location::display(ostream& o) const {
    assert(inv);
    return o << name << *inv;
}
