// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: invariant.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_INVARIANT_H
#define SYSTEM_INVARIANT_H

#include "constraint.h"
#include "constraint_container.h"

class ClockConstraint;

class Invariant : public ConstraintContainer {
public:
    Conjunction<ClockConstraint> clockconstraints;

    Invariant();

    virtual void addIntConstraint(IntConstraint* ic);
    virtual void addClockConstraint(ClockConstraint* cc);
    virtual bool isSatBy(const State* state) const;
    virtual varset_t readVars() const;
    virtual varset_t writeVars() const;

    bool constrain(State* state) const;

    virtual std::ostream& display(std::ostream& o) const;
};

////////////////////////////////////////////////////////////////////

inline bool Invariant::isSatBy(const State* state) const {
    return clockconstraints.isSatBy(state);
}

inline bool Invariant::constrain(State* state) const {
    return clockconstraints.constrain(state);
}

#endif /* SYSTEM_INVARIANT_H */
