// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: invariant.cpp 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "constraint.h"
#include "invariant.h"

#include "common/helper.h"
#include "common/message.h"

#include <cassert>
#include <ostream>

using namespace std;

Invariant::Invariant() :
    ConstraintContainer(Expression::INVARIANT)
{}

void Invariant::addIntConstraint(IntConstraint*) {
    error() << "int constraints are not supported in location invariants" << endl;
}

void Invariant::addClockConstraint(ClockConstraint* cc) {
    clockconstraints.add(cc);
}

varset_t Invariant::readVars() const {
    return clockconstraints.readVars();
}

varset_t Invariant::writeVars() const {
    return clockconstraints.writeVars();
}

ostream& Invariant::display(std::ostream& o) const {
    if (clockconstraints.empty()) {
        return o;
    }
    return o << "{" << clockconstraints << "}";
}
