// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: guard.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_GUARD_H
#define SYSTEM_GUARD_H

#include "constraint.h"
#include "constraint_container.h"

class State;

class Guard : public ConstraintContainer {
public:
    Conjunction<IntConstraint> intconstraints;
    Conjunction<ClockConstraint> clockconstraints;

    Guard();

    virtual void addIntConstraint(IntConstraint* ic);
    virtual void addClockConstraint(ClockConstraint* cc);
    virtual bool isSatBy(const State* state) const;
    virtual bool empty() const;
    virtual varset_t writeVars() const;
    virtual varset_t readVars() const;
    virtual bool operator==(const Guard& other) const;
    virtual bool operator!=(const Guard& other) const;
    bool constrain(State* state) const;

    virtual std::ostream& display(std::ostream& o) const;
};

////////////////////////////////////////////////////////////////////

inline bool Guard::operator==(const Guard& other) const {
    return (intconstraints == other.intconstraints) &&
           (clockconstraints == other.clockconstraints);
}

inline bool Guard::operator!=(const Guard& other) const {
    return !(*this == other);
}

inline bool Guard::empty() const {
    return intconstraints.empty() && clockconstraints.empty();
}

inline bool Guard::isSatBy(const State* state) const {
    return intconstraints.isSatBy(state) && clockconstraints.isSatBy(state);
}

inline bool Guard::constrain(State* state) const {
    return clockconstraints.constrain(state);
}

#endif /* SYSTEM_GUARD_H */
