// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: guard.cpp 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "guard.h"
#include "constraint.h"
#include "state.h"
#include "variable.h"

#include "common/helper.h"

#include <ostream>
#include <cassert>
#include <boost/foreach.hpp>
#define foreach BOOST_FOREACH

using namespace std;

Guard::Guard() :
    ConstraintContainer(Expression::GUARD)
{}

void Guard::addIntConstraint(IntConstraint* ic) {
    intconstraints.add(ic);
}

varset_t Guard::writeVars() const {
    return varset_t();
}

varset_t Guard::readVars() const {
    varset_t res;
    foreach(const IntConstraint* ic, intconstraints) {
        res += ic->readVars();
    }
    foreach(const ClockConstraint* cc, clockconstraints) {
        res += cc->readVars();
    }
    return res;
}

void Guard::addClockConstraint(ClockConstraint* cc) {
    clockconstraints.add(cc);
}

ostream& Guard::display(ostream& o) const {
    if (empty()) {
        return o;
    }
    o << "guard " << intconstraints;
    if (!intconstraints.empty() && !clockconstraints.empty()) {
        o << " && ";
    }
    return o << clockconstraints;
}
