// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: expression_builder.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_EXPRESSION_BUILDER_H
#define SYSTEM_EXPRESSION_BUILDER_H

#include "common/utapfwd.h"
#include <inttypes.h>

class Action;
class Assignment;
class Component;
class Constraint;
class Effect;
class Expression;
class Guard;
class Invariant;
class NameResolver;
class System;
class Target;
class Variable;

class ExpressionBuilder {
private:
    Expression* build(const UTAP::expression_t& expr, const Component* comp, Expression* result) const;
    Variable* resolve(const UTAP::expression_t& expr, const Component* proc) const;
    Constraint* buildConstraint(const UTAP::expression_t& exp, const Component* comp, Expression* result) const;
    Assignment* buildAssignment(const UTAP::expression_t& exp, const Component* comp, Expression* result) const;
    Variable* buildDotExpression(const UTAP::expression_t& exp, const Component* comp, Expression* result) const;
    const NameResolver* resolver;
public:
    ExpressionBuilder(const NameResolver* resolver) : resolver(resolver) {}

    int32_t evaluate(const UTAP::expression_t& exp, const Component* comp) const;

    Guard* buildGuard(const UTAP::expression_t& exp, const Component* comp) const;
    Target* buildTarget(const char* filename, UTAP::TimedAutomataSystem* tasystem, const System* system) const;
    Effect* buildEffect(const UTAP::expression_t& exp, const Component* comp) const;
    Action* buildAction(const UTAP::expression_t& exp, const Component* comp) const;
    Invariant* buildInvariant(const UTAP::expression_t& exp, const Component* comp) const;
};

#endif /* EXPRESSION_BUILDER_H */
