// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: expression.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_EXPRESSION_H
#define SYSTEM_EXPRESSION_H

#include <iosfwd>

class Expression {
public:
    enum type_t {
        INTEGER = 0,
        CLOCK,
        CHANNEL,
        CONSTANT,
        ASSIGNMENT,
        CONSTRAINT,
        GUARD,
        EFFECT,
        INVARIANT,
        LOCATION,
        ACTION,
        TARGET,
        UNKNOWN
    };
    type_t type;
    virtual std::ostream& display(std::ostream& o) const = 0;

protected:
    explicit Expression(type_t type) : type(type) {}
    virtual ~Expression() {}
};

inline std::ostream& operator<<(std::ostream& o, const Expression& expr) {
    return expr.display(o);
}

#endif /* SYSTEM_EXPRESSION_H */
