// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: effect.h 941 2016-09-16 12:47:37Z Kevin Grimm $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_EFFECT_H
#define SYSTEM_EFFECT_H

#include "expression.h"
#include "varset.h"

#include <vector>

class ClockReset;
class IntAssignment;
class State;

class Effect : public Expression {
public:
    std::vector<IntAssignment*> intassigns;
    std::vector<ClockReset*> resets;

    Effect();

    virtual varset_t writeVars() const;
    virtual varset_t readVars() const;
    virtual bool empty() const {
        return intassigns.empty() && resets.empty();
    }
    virtual bool operator==(const Effect& other) const;
    virtual bool operator!=(const Effect& other) const {
        return !(*this == other);
    }
    virtual void apply(State* state) const;
    virtual std::ostream& display(std::ostream& o) const;
};

#endif /* SYSTEM_EFFECT_H */
