// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: edge.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_EDGE_H
#define SYSTEM_EDGE_H

#include <inttypes.h>
#include <iosfwd>

class Action;
class Effect;
class Guard;
class Location;
class Process;
class State;

class Edge {
public:
    enum type_t {TAU = 0, BANG, QUE};
private:
    Action* action;
    type_t type;
public:

    uint32_t idInProcess;
    uint32_t idInSystem;
    uint32_t abstract_id;
    Location* src;
    Location* dst;
    Effect* effect;
    Guard* guard;

    Edge(uint32_t idInProcess, uint32_t idInSystem);
    ~Edge();

    void setAction(Action* action);
    type_t getType() const {return type; }

    Action* getAction() const {return action; }

    const Process* getProcess() const;
    Process* getProcess();

    bool operator==(const Edge& other) const;

    std::ostream& display(std::ostream& o) const;
};

////////////////////////////////////////////////////////////////////

inline std::ostream& operator<<(std::ostream& o, const Edge& edge) {
    return edge.display(o);
}

#endif /* SYSTEM_EDGE_H */
