// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: constraint_container.h 816 2011-09-10 13:19:07Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_CONSTRAINT_CONTAINER_H
#define SYSTEM_CONSTRAINT_CONTAINER_H

#include "expression.h"
#include "varset.h"

class ClockConstraint;
class IntConstraint;
class Location;
class State;
class Variable;

class ConstraintContainer : public Expression {
protected:
    ConstraintContainer(Expression::type_t type) : Expression(type) {}
    virtual ~ConstraintContainer() {}
public:
    virtual void addIntConstraint(IntConstraint* ic) = 0;
    virtual void addClockConstraint(ClockConstraint* cc) = 0;
    virtual bool isSatBy(const State* state) const = 0;
    virtual varset_t readVars() const = 0;
    virtual varset_t writeVars() const = 0;
};

#endif /* SYSTEM_CONSTRAINT_CONTAINER_H */
