// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: component.h 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SYSTEM_COMPONENT_H
#define SYSTEM_COMPONENT_H

#include <vector>
#include <iosfwd>
#include <string>

class Integer;
class Clock;
class Channel;

class Component {
public:
    const std::string name;
    const Component* parent;

    std::vector<Integer*> ints;
    std::vector<Clock*> clocks;
    std::vector<Channel*> channels;

    Component(const std::string& name, Component* parent) : name(name), parent(parent) {}
    virtual ~Component() {}
    virtual const Component* getComponent(const std::string& compname) const;
    virtual std::ostream& display(std::ostream& o) const;
};

inline std::ostream& operator<<(std::ostream& o, const Component& c) {
    return c.display(o);
}

#endif /* SYSTEM_COMPONENT_H */
