// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: component.cpp 941 2016-05-27 12:47:37Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "system/component.h"
#include "system/variable.h"

#include <cassert>
#include <iostream>
#include <boost/foreach.hpp>
#define foreach BOOST_FOREACH

using namespace std;

const Component* Component::getComponent(const std::string& compname) const {
    if (name == compname) {
        return this;
    } else {
        assert(parent);
        return parent->getComponent(compname);
    }
}

ostream& Component::display(ostream& o) const {
    foreach(const Clock* c, clocks) {
        if (c->name != "t(0)") {
            o << *c << ";" << endl;
        }
    }
    foreach(const Integer* i, ints) {
        o << *i << ";" << endl;
    }
    foreach(const Channel* c, channels) {
        o << *c << ";" << endl;
    }
    return o;
}
