// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: successor_generator.h 936 2016-05-27 10:27:23Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SEARCH_SUCCGESSOR_GENERATOR_H
#define SEARCH_SUCCGESSOR_GENERATOR_H

#include <inttypes.h>
#include <vector>

class State;
class InterferenceFilter;
class Options;
class Task;
class System;
class Transition;

class SuccessorGenerator {
private:
    const System* system;
    const Options* opts;
    int32_t indep_size;
    InterferenceFilter* filter;
    int32_t depth;
    int32_t interference_level;
    void generateApplicableTransitions(const State* state, std::vector<const Transition*>& succs) const;
public:
    SuccessorGenerator(const Task* task, const Options* opts, int32_t indep_size);

    bool delay(State* state) const;
    void generateSuccessors(const State* state, std::vector<State*>& succs);
};

#endif /* SEARCH_SUCCGESSOR_GENERATOR_H */
