// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: normalizer.h 935 2016-05-27 10:23:55Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SEARCH_NORMALIZE_H
#define SEARCH_NORMALIZE_H

#include <inttypes.h>
#include <vector>

class System;
class State;
class Process;
class Location;
class ClockConstraint;

class Normalizer {
protected:
    const System* system;
    Normalizer(const System* system) : system(system) {}

    virtual void init();
    virtual void process(const Process*, const Location*, const ClockConstraint*) = 0;
public:
    virtual ~Normalizer() {}
    virtual void normalize(State* next) const = 0;
};

////////////////////////////////////////////////////////////////////

class LocalLUNormalizer : public Normalizer {
protected:
    typedef std::vector<std::vector<std::vector<int32_t>>> array_t;
    array_t lower;
    array_t upper;
    const uint32_t nrClocks;
    const uint32_t nrProcs;

    virtual void close(array_t& bounds, const Process* proc);
    virtual void reserveMemory(array_t& array) const;
    virtual void process(const Process* proc, const Location* loc, const ClockConstraint* cc);
    virtual void prepareNormalization(std::vector<int32_t>& ceils, const array_t& bounds, const State* next) const;

public:
    LocalLUNormalizer(const System* system);
    virtual void normalize(State* next) const;
};

#endif /* SEARCH_NORMALIZE_H */
