// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: interference.h 935 2016-05-27 10:23:55Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SEARCH_INTERFERENCE_H
#define SEARCH_INTERFERENCE_H

#include <inttypes.h>
#include <vector>

class Edge;
class Options;
class State;
class Task;
class Transition;

class InterferenceFilter {
private:
    const Task* task;
    const Options* opts;
    std::vector<std::vector<int32_t>> inter;
    int32_t max_closure;
    int32_t interference_level;

    bool all_relevant_enabled(const State* state, const std::vector<State*>& succs) const;
    bool exists_relevant_enabled(const State* state) const;
    bool interfere(const Transition* trans1, const Transition* trans2) const;
    bool interfere(const Edge* edge1, const Edge* edge2) const;
    bool innocent(const Transition* trans) const;
    bool innocentLocations(const Edge* edge) const;
    bool innocentIntegers(const Edge* edge) const;
    void generate_closure();

public:
    InterferenceFilter(const Task* task, const Options* opts);
    bool interferes(const Transition* t1, const Transition* t2, int32_t bound) const;
    void label(std::vector<State*>& succs) const;
};

#endif /* SEARCH_INTERFERENCE_H */
