// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: heuristic.h 934 2016-05-27 10:19:41Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SEARCH_HEURISTIC_H
#define SEARCH_HEURISTIC_H

#include "system/edge.h"

#include <vector>
#include <inttypes.h>

class State;
class Options;
class Task;
class Cache;

class Heuristic {
protected:
public:
    const Task* task;
    const Options* opts;
    Cache* cache;

    Heuristic(const Task* task, const Options* opts);
    virtual ~Heuristic() {}
    virtual int32_t compute(const State* state) = 0;
    int32_t eval(const State* state);
};

////////////////////////////////////////////////////////////////////

class NullHeuristic : public Heuristic {
public:
    NullHeuristic(const Task*, const Options*) : Heuristic(NULL, NULL) {}
    int32_t compute(const State*) {return 0; }
};

////////////////////////////////////////////////////////////////////

class AStarHeuristic : public Heuristic {
private:
    Heuristic* heuristic;
    int32_t depth_index;
public:
    AStarHeuristic(const Task* task, const Options* opts, Heuristic* heuristic);

    int32_t compute(const State* state);
};

#endif /* SEARCH_HEURISTIC_H */
