// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: heuristic.cpp 934 2016-05-27 10:19:41Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#include "cache.h"
#include "heuristic.h"

#include "system/state.h"
#include "system/system.h"
#include "system/task.h"

#include <cassert>
#include <climits>
#include <iostream>
#include <sys/times.h>

Heuristic::Heuristic(const Task* task, const Options* opts) :
    task(task),
    opts(opts),
    cache(new NoCache(0))
{}

int32_t Heuristic::eval(const State* state) {
    assert(cache);
    int32_t& hval = cache->lookup(state);
    if (hval == Cache::NOT_FOUND) {
        hval = compute(state);
    }
    return hval;
}

////////////////////////////////////////////////////////////////////

AStarHeuristic::AStarHeuristic(const Task* task, const Options* opts, Heuristic* heuristic) :
    Heuristic(task, opts),
    heuristic(heuristic),
    depth_index(task->system->builder->getField("depth")) {
    assert(depth_index != -1);
}

int32_t AStarHeuristic::compute(const State* state) {
    assert(state->extra(depth_index) >= 0);
    int32_t result = heuristic->compute(state);
    if (result == INT_MAX) {
        return result;
    } else {
        return result + state->extra(depth_index);
    }
}
