// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: context.h 933 2016-05-27 10:17:48Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SEARCH_CONTEXT_H
#define SEARCH_CONTEXT_H

#include "search_engine.h"
#include <vector>

class State;
class OpenList;

class ContextSearchEngine : public SearchEngine {
private:
    OpenList** next;
    SearchEngine* cse;
    bool generateInitialSuccessors(State* initial, std::vector<State*>& initial_succs);
public:
    ContextSearchEngine(const Task* task, const Options* opts) :
        SearchEngine(task, opts), cse(NULL) {}
    virtual void init(OpenList*, ClosedList*, Heuristic*, Normalizer*);
    virtual void explore(State* initial);
};

#endif /* SEARCH_CONTEXT_H */
