// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: closed_list.h 932 2016-05-27 10:16:04Z Martin Wehrle $
//
////////////////////////////////////////////////////////////////////

#ifndef SEARCH_CLOSED_LIST_H
#define SEARCH_CLOSED_LIST_H

#include <ext/hash_map>
#include <ext/slist>
#include <inttypes.h>

class State;

class ClosedList {
protected:
    typedef __gnu_cxx::slist<const State*> list_t;
    typedef __gnu_cxx::hash_map<uint32_t, list_t> hash_t;
    hash_t states;
    uint32_t nrStates;

    virtual bool equal(const State* s1, const State* s2) const;
public:
    ClosedList() : nrStates(0) {}
    virtual ~ClosedList() {}

    // returns a state that is greater or equal to the given state and
    // was already in this ClosedList. If there is no such state NULL
    // is returned
    virtual const State* insert(State* state);

    // return a state that is greater or equal to the given state from
    // this ClosedList. If there is no such state, NULL is returned.
    virtual const State* contains(const State* state) const;
    virtual uint32_t size() const {return nrStates; }
};

/////////////////////////////////////////////////////

class AStarClosedList : public ClosedList {
    // in optimal search performed with A*, the inclusion check has to
    // be refined when states are checked if they are already in
    // closed.
public:
    explicit AStarClosedList(int depth) : ClosedList(), depth(depth) {}

    virtual const State* insert(State* state);
    virtual const State* contains(const State* state) const;

private:
    int depth;
};

///////////////////////////////////////////////////

#endif /* SEARCH_CLOSED_LIST_H */
