// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: pdb_heuristic.cpp 814 2011-09-10 12:44:37Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#include "pdb_heuristic.h"
#include "pdb_hash.h"

#include "common/option.h"
#include "system/state.h"
#include "system/system.h"
#include "system/task.h"
#include <boost/foreach.hpp>
#define foreach BOOST_FOREACH

using namespace std;

PDBHeuristic::PDBHeuristic(const Task* task, const Options* opts) : 
    Heuristic(task, opts)
{
    foreach (const string& filename, opts->pdb_filenames) {
	pdbs.push_back(new PDBHash(task->system, filename.c_str()));
    }    
}

int32_t PDBHeuristic::compute(const State* state) {
    int32_t res = 0;
    for (uint32_t i = 0; i < pdbs.size(); i++) {
	int32_t val = pdbs[i]->lookup(state);
	if (val == INT_MAX) {
	    return INT_MAX;
	} else {
	    //res = std::max(res, val);
	    res += val;
	}
    }
    return res;
}
