// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: pdb_hash.h 814 2011-09-10 12:44:37Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#ifndef PDB_HASH_H
#define PDB_HASH_H

#include <ext/hash_map>
#include <ext/slist>
#include <inttypes.h>
#include <iosfwd>
#include <vector>

class System;
class State;
class DiscretePart;

class PDBHash {
private:
    typedef std::pair<const State*, int32_t> state_t; // state and corresponding heuristic value
    typedef __gnu_cxx::slist<state_t> list_t;
    typedef __gnu_cxx::hash_map<uint32_t, list_t> pdb_t;

    const System* system;
    pdb_t pdb;
    std::vector<int32_t> abstracted_procs;
    std::vector<int32_t> abstracted_ints;
    std::vector<int32_t> abstracted_clocks;
    
    void parse(std::istream& in, std::vector<int32_t>& abstracted);
    void parseHeader(std::istream& in);
    
    DiscretePart abstract(const State* state) const;

public:
    PDBHash(const System* system, const char* filename);
    int32_t lookup(const State* state) const;
    void insert(const State* state, int32_t heuristic_value);
};   

#endif /* PDB_HASH_H */
