// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: gd.h 814 2011-09-10 12:44:37Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#ifndef GD_HEURISTIC_H
#define GD_HEURISTIC_H

#include "common/matrix.h"
#include "search/heuristic.h"

#include <inttypes.h>
#include <vector>

class Task;
class State;

class GDHeuristic : public Heuristic {
protected:
    std::vector<Matrix> matrices;

    virtual void update(int32_t& result, int32_t value) const = 0;
public:
    GDHeuristic(const Task* task, const Options* opts);
    virtual ~GDHeuristic() {}

    virtual void init(const std::vector<bool>& abstracted);
    virtual int32_t compute(const State* state);
};

////////////////////////////////////////////////////////////////////

class GDMAXHeuristic : public GDHeuristic {
private:
    void update(int32_t& result, int32_t value) const { result = std::max(result, value); }    
public:
    GDMAXHeuristic(const Task* task, const Options* opts) : GDHeuristic(task, opts) {}
};

////////////////////////////////////////////////////////////////////

class GDSUMHeuristic : public GDHeuristic {
private:    
    void update(int32_t& result, int32_t value) const { result += value; }    
public:
    GDSUMHeuristic(const Task* task, const Options* opts) : GDHeuristic(task, opts) {}
};

#endif /* GD_HEURISTIC_H */
