// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffloc.h 137 2008-02-21 17:38:32Z sebastian $
//
////////////////////////////////////////////////////////////////////

#ifndef FF_LOC_H
#define FF_LOC_H

#include <inttypes.h>
#include <vector>
#include <string>
#include <iosfwd>

namespace ff {

    // forward declarations
    class Edge;
    
    class Location {
    private:
	static const int32_t not_activated = -1;
	std::string name;
	uint32_t id;
	int32_t activationLevel;
	std::vector<Edge*> outgoing;
	std::vector<Edge*> incoming;

    public:
	Location();

	void init() {
	    activationLevel = not_activated;
	}
	
	void addIncomingEdge(Edge* edge);	
	void addOutgoingEdge(Edge* edge);	

	const std::vector<Edge*>& getIncomingEdges() const;
	const std::vector<Edge*>& getOutgoingEdges() const;
	
	uint32_t getID() const;
	void setID(uint32_t id);
	
	void setName(const std::string& name);
	const std::string& getName() const;

	void setActivationLevel(int32_t level);
	int32_t getActivationLevel() const;
	
	std::ostream& display(std::ostream& o) const;
    };

    ////////////////////////////////////////////////////////////////////

    inline const std::vector<Edge*>& Location::getIncomingEdges() const {
	return incoming;
    }

    inline const std::vector<Edge*>& Location::getOutgoingEdges() const {
	return outgoing;
    }
   
    inline uint32_t Location::getID() const {
	return id;
    }    
    
    inline void Location::setID(uint32_t id) {
	this->id = id;
    }
        
    inline const std::string& Location::getName() const {
	return name;
    }

    inline void Location::setName(const std::string& name) {
	this->name = name;
    }
    
    inline void Location::setActivationLevel(int32_t level) {
	if (activationLevel == not_activated) {
	    activationLevel = level;
	}
    }

    inline int32_t Location::getActivationLevel() const {
	return activationLevel;
    }

    inline std::ostream& operator<<(std::ostream& o, const Location& loc) {
	return loc.display(o);
    }
}

#endif /* FF_LOC_H */
