// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffloc.cpp 137 2008-02-21 17:38:32Z sebastian $
//
////////////////////////////////////////////////////////////////////

#include "ff_heuristic/ffloc.h"
#include "ff_heuristic/ffedge.h"

#include <iostream>
#include <cassert>

namespace ff {

    using namespace std;
    
    Location::Location() : 
	name("no name"),
	id(0),
	activationLevel(-1)
    {}

    void Location::addOutgoingEdge(Edge* edge) {
	assert(edge != 0);
	outgoing.push_back(edge);
    }

    void Location::addIncomingEdge(Edge* edge) {
	assert(edge != 0);
	incoming.push_back(edge);
    }
        
    ostream& Location::display(ostream& o) const {
	return o << name;
    }
}
