// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffhelper.h 58 2008-01-11 15:15:59Z sebastian $
//
////////////////////////////////////////////////////////////////////

#ifndef FF_HELPER_H
#define FF_HELPER_H

#include <vector>
#include <algorithm>

namespace ff {
    
    template<class T> static T* create() { 
	return new T; 
    }
    
    template<class T> struct destroy {
	void operator()(T* t) { delete t; }
    };
    
    template<class T> void destroyVector(std::vector<T*>& v) {
	std::for_each(v.begin(), v.end(), destroy<T>());    
    }
    
    template<class T> static void initVector(std::vector<T*>& vec, size_t size) {
	vec.resize(size);
	std::generate(vec.begin(), vec.end(), create<T>);
    }
}

#endif /* FF_HELPER_H */
