// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffgoal.cpp 69 2008-01-14 09:09:37Z sebastian $
//
////////////////////////////////////////////////////////////////////

#include "ff_heuristic/ffgoal.h"
#include "ff_heuristic/ffloc.h"
#include <iostream>
#include <cassert>

namespace ff {
    
    using namespace std;
    
    Goal::Goal(const PtrSet<Location>& reachedLocations) : 
	reachedLocations(reachedLocations),
	locations(),
	firstNonReached(0),
	guard()
    {
    }
    
    void Goal::addLocation(Location* loc) {
	assert(loc != 0);
	locations.push_back(loc);
    }
    
    void Goal::addConstraint(IntegerConstraint* ic) {
	assert(ic != 0);
	guard.addConstraint(ic);
    }

    ostream& Goal::display(ostream& o) const {
	for (uint32_t i = 0; i < locations.size(); i++) {
	    o << locations[i]->getName() << " ";
	}
	return o << guard;
    }
}
