// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffedge.cpp 184 2008-06-04 13:03:13Z sebastian $
//
////////////////////////////////////////////////////////////////////

#include "ff_heuristic/ffedge.h"
#include "ff_heuristic/ffloc.h"
#include "ff_heuristic/ffiguard.h"
#include "ff_heuristic/ffassign.h"
#include "ff_heuristic/ffhelper.h"
#include <iostream>
#include <cassert>

namespace ff {

    using namespace std;
    
    uint32_t Edge::nrEdges = 0;
    
    Edge::Edge() :
	iguard(),
	assigns(),
	type(TAU),
	procID(0),
	chanNr(-1),
	selected(false),
	to(NULL), 
	from(NULL),
	id(nrEdges++)
    {}	

    Edge::~Edge() {
	destroyVector(assigns);
    }

    void Edge::addAssignment(IntegerAssignment* ass) {
	assert(ass != 0);
	assigns.push_back(ass);
    }

    void Edge::addConstraint(IntegerConstraint* ic) {
	assert(ic != 0);
	iguard.addConstraint(ic);
    }

    ostream& Edge::display(ostream& o) const {
	o << from->getName() << " -> " << to->getName() << " {";
	if (!iguard.empty()) {
	    o << " guard " << iguard;
	}
	switch (getType()) {
	case BANG: o << " sync " << chanNr << "!"; break;
	case QUE:  o << " sync " << chanNr << "?"; break;
	default: break;	    
	}
	if (!assigns.empty()) {
	    o << " assign ";
	    for (uint32_t i = 0; i < assigns.size() - 1; ++i) {
		o << *assigns[i] << ", ";
	    }
	    o << *assigns.back();
	}
	return o << " }";	
    }
}
