// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffback.h 810 2017-01-12 15:21:54Z Kevin Grimm $
//
////////////////////////////////////////////////////////////////////

#ifndef FFBACK_H
#define FFBACK_H

#include "ff_heuristic/ffheur.h"
#include "ff_heuristic/ffsolution.h"

namespace ff {

    class FFBackHeuristic : public FFHeuristic {
    protected:
	static const int32_t not_activated = -1;		
	RelaxedSolution solution;
	int32_t selectedEdges;
	
	virtual bool processEdge(const Edge* edge);
	virtual void init();
	virtual void copyIntegerVars();
	
	void makeTarget(const Goal& goal);
	virtual bool makeTarget(const Edge* edge, int32_t level);
	void resolveLocation(const Location* loc, int32_t level);
	void resolveAssignment(const Variable* var, int32_t value, int32_t level);
	void processEdge(const Edge* edge, int32_t level);
    public:
	FFBackHeuristic(const Task* task, const Options* opts);	
	virtual int32_t compute(const State* state);

	bool checkAssignment(const IntegerAssignment* a, int32_t value, int32_t level);
	bool checkAssignment(const ConstAssignment* a, int32_t value, int32_t level);
	bool checkAssignment(const VarAssignment* a, int32_t value, int32_t level);
	bool checkAssignment(const NullAssignment* a, int32_t value, int32_t level);

	void resolveSupporter(const Supporter& s, int32_t level);
    };

    ////////////////////////////////////////////////////////////////////

    inline bool FFBackHeuristic::processEdge(const Edge* edge) { 	
	edge->setActivationLevel(system->getLevel());
	edge->to->setActivationLevel(system->getLevel() + 1);
	return FFHeuristic::processEdge(edge);
    }



/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////

    class UA_FFBackHeuristic : public FFBackHeuristic{
	private:
	    std::vector<bool> edgeList;
	    bool newEdgeAdded = false;
	    Cache* cacheUA;
	protected:
	    virtual bool makeTarget(const Edge* edge, int32_t level);
	public:
	    UA_FFBackHeuristic(const Task* task, const Options* opts);   
	    bool hasNewEdge();
	    std::vector<bool> getPlanEdges(const State* state,vector<bool> newList);	            

    };
}

#endif /* FFBACK_H */
