// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffastore.h 69 2008-01-14 09:09:37Z sebastian $
//
////////////////////////////////////////////////////////////////////

#ifndef FF_ASTORE_H // don't change the name of the define since it is
		    // also used in ffastore.cpp
#define FF_ASTORE_H

#include <ext/slist>
#include <vector>
#include <iosfwd>

namespace ff {

    // forward declarations
    class IntegerAssignment;
    
    class AssignmentStore {
    private:
	size_t size;
	std::vector<bool> members;
	__gnu_cxx::slist<IntegerAssignment*> assigns;
    public:
	AssignmentStore();

	void assign(size_t size);
	
	void add(IntegerAssignment* assign);
	void add(const std::vector<IntegerAssignment*>& assigns);
	bool applyAssignments();
	void clear();
	std::ostream& display(std::ostream& o) const;
    };

    inline std::ostream& operator<<(std::ostream& o, const AssignmentStore& as) {
	return as.display(o);
    }
}

#include "ff_heuristic/ffastore.cpp"

#endif /* FF_ASTORE_H */
