// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffastore.cpp 69 2008-01-14 09:09:37Z sebastian $
//
////////////////////////////////////////////////////////////////////

// HACK! Ignore this if used as a top-level compile target.
#ifdef FF_ASTORE_H

#include "ff_heuristic/ffastore.h"
#include "ff_heuristic/ffassign.h"

#include <inttypes.h>
#include <iostream>
#include <cassert>

namespace ff {

    using namespace std;
    using __gnu_cxx::slist;
    
    inline AssignmentStore::AssignmentStore() : 
	assigns() 
    {}

    inline void AssignmentStore::assign(size_t size) {
	this->size = size;
	clear();
    }
    
    inline void AssignmentStore::add(IntegerAssignment* assign) {
	assert(int32_t(members.size()) > assign->getID());
	if (!members[assign->getID()]) {
	    members[assign->getID()] = true;
	    assigns.push_front(assign);	    
	}
    }

    inline void AssignmentStore::add(const vector<IntegerAssignment*>& assigns) {
	for (uint32_t i = 0; i < assigns.size(); i++) {
	    add(assigns[i]);
	}
    }

    inline bool AssignmentStore::applyAssignments() {
	slist<IntegerAssignment*>::iterator it = assigns.begin();
	bool result = false;
	while (it != assigns.end()) {
	    result |= (*it)->apply();
	    if ((*it)->idempotent()) {
		it = assigns.erase(it);
	    } else {
		++it;	    
	    }
	}
	return result;
    }

    inline void AssignmentStore::clear() {
	assigns.clear();
	members.assign(size, false);
    }
    
    inline ostream& AssignmentStore::display(ostream& o) const {
	slist<IntegerAssignment*>::const_iterator it;
	for (it = assigns.begin(); it != assigns.end(); ++it) {
	    o << **it << endl;
	} 
	return o;
    }
}

#endif /* FF_ASTORE_H */

