// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffassign.cpp 137 2008-02-21 17:38:32Z sebastian $
//
////////////////////////////////////////////////////////////////////

#include "ff_heuristic/ffassign.h"
#include "ff_heuristic/ffvar.h"
#include "ff_heuristic/ffback.h"
#include <ostream>

namespace ff {
    
    using namespace std;
    
    VarAssignment::VarAssignment(int32_t id, Variable* lhs, Variable* rhs) : 
	IntegerAssignment(lhs, id),
	rhs(rhs) 
    {}

    bool VarAssignment::accept(FFBackHeuristic* heur, int32_t value, int32_t level) const {
	return heur->checkAssignment(this, value, level);
    }

    ostream& VarAssignment::display(ostream& o) const {
	return o << lhs->getName() << " := " << rhs->getName();
    }
    
    ////////////////////////////////////////////////////////////////////
    
    ConstAssignment::ConstAssignment(int32_t id, Variable* lhs, int32_t rhs) : 
	IntegerAssignment(lhs, id),
	rhs(rhs) 
    {}

    bool ConstAssignment::accept(FFBackHeuristic* heur, int32_t value, int32_t level) const {
	return heur->checkAssignment(this, value, level);
    }

    ostream& ConstAssignment::display(ostream& o) const {
	return o << lhs->getName() << " := " << rhs;
    }

    ////////////////////////////////////////////////////////////////////
    
    ostream& NullAssignment::display(ostream& o) const {
	return o << "no assign";
    }    
}
