// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: ffadd.h 810 2011-09-03 15:21:54Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#ifndef FFADD_H
#define FFADD_H

#include "ff_heuristic/ffheur.h"

namespace ff {

    class FFAddHeuristic : public FFHeuristic {
    protected:
	virtual bool processEdge(const Edge* edge);
	virtual void init();
	
    public:
	FFAddHeuristic(const Task* task, const Options* opts);	
	int32_t compute(const State* state);
    };

    ////////////////////////////////////////////////////////////////////

    inline bool FFAddHeuristic::processEdge(const Edge* edge) { 	
	edge->setActivationLevel(system->getLevel());
	edge->to->setActivationLevel(system->getLevel() + 1);
	return FFHeuristic::processEdge(edge);
    }
}

#endif /* FFADD_H */
