// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: option.h 839 2016-11-29 19:49:17Z Kevin Grimm $
//
////////////////////////////////////////////////////////////////////

#ifndef COMMON_OPTION_H
#define COMMON_OPTION_H

#include <vector>
#include <string>
#include <iosfwd>
#include <inttypes.h>

enum heuristic_opt {
    NULL_HEURISTIC = 0,
    DU_HEURISTIC,
    DL_HEURISTIC,
    HL_HEURISTIC,
    PDB_HEURISTIC,
    HU_HEURISTIC,
    H_ADD_HEURISTIC,
    CG_HEURISTIC
};

enum cache_opt {
    NO_CACHE = 0,
    BITSTATE_CACHE,
    DISCRETE_CACHE,
    WHOLE_STATE_CACHE
};

enum search_opt {
    BFS_SEARCH = 0,
    DFS_SEARCH,
    GREEDY_SEARCH,
    A_STAR_SEARCH,
    UT_SEARCH,
    UA_SEARCH
};

enum trace_opt {
    NO_TRACE = 0, 
    STATISTIC_TRACE,
    SHOW_TRACE,	  
    SYMBOLIC_TRACE
};

enum icb_opt {
    ICB_NO = 0,
    ICB_PROC,
    ICB_INTERFERENCE,
    ICB_SINGLE,
    ICB_ALL
};

enum ua_opt {
    UA_PLATEAUGUARD
};

////////////////////////////////////////////////////////////////////

class Options {
private:
    void parseCmdLine(int argc, char** argv);
public:
    heuristic_opt heuristic;
    cache_opt cache;
    search_opt search;
    trace_opt trace;
    icb_opt icb;
    ua_opt ua;
    bool quiet;
    bool debug_mode;
    bool memtime;
    bool batch_mode;
    bool new_syntax;
    bool ce_with_enabled;
    bool ce;
    bool ce_closure;
    int32_t ce_dist;
    int32_t ua_guard;
    bool dump_state_space;
    bool eval_initial;
    std::string state_space_filename;
    std::string ta_file;
    std::string q_file;
    std::vector<std::string> pdb_filenames;
    
    Options(int argc, char** argv) {
	// set default values
	heuristic        = NULL_HEURISTIC;
	cache            = NO_CACHE;
	search           = BFS_SEARCH;
	trace            = STATISTIC_TRACE;
	quiet            = false;
	debug_mode       = false;
	memtime          = true;
	batch_mode       = false;
	new_syntax       = false;
	ua_guard	 = 0;
	icb              = ICB_NO;
	ce_dist          = 0; 
	ce_with_enabled  = false;
	ce               = false;
	ce_closure       = false;
	dump_state_space = false;
	eval_initial     = false;
	
	parseCmdLine(argc, argv);
    }
};

std::ostream& operator<<(std::ostream& o, const Options& opts);

#endif /* COMMON_OPTION_H */
