// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: message.h 630 2010-04-27 13:52:24Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#ifndef COMMON_MESSAGE_H
#define COMMON_MESSAGE_H

#include <iostream>
#include <cstdlib>

class Message {
protected:
    typedef std::ostream& (*func_t)(std::ostream&);
    std::ostream& out;
    bool silent;
    Message& operator=(const Message&);
public:
    Message(std::ostream& out, bool silent=false) : 
	out(out), silent(silent) {}   

    virtual ~Message() {}; 

    void setSilent(bool flag) {
	silent = flag;
    }

    template<class T>
    Message& operator<<(const T& t) {
	if (!silent) {
	    out << t;
	}
	return *this;
    }

    Message& operator<<(const func_t& f) {
	if (!silent) {
	    out << f;
	}
	return *this;
    }    
};

////////////////////////////////////////////////////////////////////

class Debug : public Message {
protected:
    Debug() : Message(std::cout) {}
public:
    friend Debug& debug();
};

inline Debug& debug() {
    static Debug d;
    return d;
}

////////////////////////////////////////////////////////////////////

class Warning : public Message {
protected:
    Warning() : Message(std::cout) {}
public:
    friend Warning warning();
};

inline Warning warning() {
    static Warning w;
    w << "warning: ";
    return w;
}

////////////////////////////////////////////////////////////////////

class Error : public Message {
protected:
    Error() : Message(std::cerr) {}
public:
    virtual ~Error() { exit(1); }
    friend Error error();
};

inline Error error() {
    static Error e;
    e << "error: ";
    return e;
}

#endif /* COMMON_MESSAGE_H */
