// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: memstat.h 813 2011-09-10 12:31:51Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#ifndef COMMON_MEMSTAT_H
#define COMMON_MEMSTAT_H

#include <sys/times.h>
#include <fstream>

class MemStat
{
private:    
    static const int UTIME = 13;
    static const int STIME = 14;
    static const int CUTIME = 15;
    static const int CSTIME = 16;
    static const int VSIZE = 22;   
    
    static const int NUM_PROC_ENTRIES = 40; // see man 5 proc
    
    double cstime;
    double cutime;
    unsigned long vsize;            // max allocated virtual memory in KB
    double stime;                   // system time in s
    double utime;                   // user time in s   
    int exit_code;                  // program's exit code
    clock_t begin;
    clock_t end;

    tms buf;
    std::ifstream file;   

    MemStat();
    void show_info();
    void collect_info(int exit_code);
    
    static MemStat* memstat;
    static void exit(int exit_code, void*);
    static void error_handle(int exit_code);

public:
    static MemStat& getMemStat(); // call this function if you want the information   
};

#endif /* COMMON_MEMSTAT_H */
