// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: matrix.h 813 2011-09-10 12:31:51Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#ifndef COMMON_MATRIX_H
#define COMMON_MATRIX_H

#include <inttypes.h>
#include <iosfwd>
#include <vector>

class Matrix {
private:
    std::vector<int32_t> data;
    uint32_t size;
public:
    explicit Matrix(uint32_t size = 0);
    
    int32_t& at(uint32_t i, uint32_t j);
    int32_t at(uint32_t i, uint32_t j) const;
    void floyd_warshall();
    
    std::ostream& display(std::ostream& o) const;
};

inline std::ostream& operator<<(std::ostream& o, const Matrix& matrix) {
    return matrix.display(o);
}

#endif /* COMMON_MATRIX_H */
