// -*- mode: C++; c-file-style: "stroustrup"; c-basic-offset: 4; -*-
////////////////////////////////////////////////////////////////////
//
// $Id: matrix.cpp 813 2011-09-10 12:31:51Z Sebastian Kupferschmid $
//
////////////////////////////////////////////////////////////////////

#include "matrix.h"
#include <iostream>
#include <iomanip>
#include <climits>

using namespace std;

Matrix::Matrix(uint32_t size) :
    data(size * size, INT_MAX),
    size(size)
{	
    for (uint32_t j = 0; j < size; j++) {
	at(j, j) = 0;
    }
}

int32_t& Matrix::at(uint32_t i, uint32_t j) {
    return data[i + j*size];
}

int32_t Matrix::at(uint32_t i, uint32_t j) const {
    return data[i + j*size];
}

void Matrix::floyd_warshall() {
    for (uint32_t k = 0; k < size; k++) {
	for (uint32_t i = 0; i < size; i++) {
	    for (uint32_t j = 0; j < size; j++) {
		if (at(i, k) == INT_MAX || at(k, j) == INT_MAX) {
		    // noop
		} else {
		    at(i, j) = min( at(i,j), at(i, k) + at(k, j));
		}
	    }
	}
    }
}

ostream& Matrix::display(ostream& o) const {
    for (uint32_t i = 0; i < size; ++i) {
	for (uint32_t j = 0; j < size; ++j) {
	    o << setw(5); 
	    if (at(i, j) == INT_MAX) {
		o << "inf";
	    } else {
		o << at(i, j);
	    }
	}
	o << endl;
    }
    return o;
}
